function [residual, g1, g2, g3] = gov_initial_ss_static(y, x, params)
%
% Status : Computes static model for Dynare
%
% Inputs : 
%   y         [M_.endo_nbr by 1] double    vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1] double     vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1] double   vector of parameter values in declaration order
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the static model equations 
%                                          in order of declaration of the equations.
%                                          Dynare may prepend or append auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by M_.endo_nbr] double    Jacobian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g2        [M_.endo_nbr by (M_.endo_nbr)^2] double   Hessian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g3        [M_.endo_nbr by (M_.endo_nbr)^3] double   Third derivatives matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

residual = zeros( 22, 1);

%
% Model equations
%

T20 = params(2)^params(4);
T142 = 1-x(4)*x(1)/(y(2)*y(7));
lhs =x(2)*y(1);
rhs =1-x(4)+y(1)*x(3);
residual(1)= lhs-rhs;
lhs =y(6);
rhs =1-y(6)*x(3)*T20*y(2)^(params(4)-1)/y(6);
residual(2)= lhs-rhs;
lhs =y(5);
rhs =1-y(5)*T20*(y(2)*y(7))^(params(4)-1)/y(5);
residual(3)= lhs-rhs;
lhs =y(4);
rhs =y(6)/y(5);
residual(4)= lhs-rhs;
lhs =y(7);
rhs =x(4)+(1-x(4))*y(4)^(1/(1-params(4)));
residual(5)= lhs-rhs;
lhs =y(10);
rhs =y(5)*(y(2)*(1-y(9))*y(11)+y(12)+y(22)+y(4)*(y(11)*y(2)*y(9)+y(21)));
residual(6)= lhs-rhs;
lhs =y(17);
rhs =y(5)*(y(22)+y(12)+y(2)*y(19));
residual(7)= lhs-rhs;
lhs =y(16);
rhs =y(6)*(y(21)+y(2)*y(18));
residual(8)= lhs-rhs;
lhs =y(12);
rhs =params(1)*y(14)-y(20)+y(12)*x(4)*x(1)/(y(2)*y(7));
residual(9)= lhs-rhs;
lhs =y(11)*x(2)*x(1)*(x(4)+y(9)-1)/x(4);
rhs =y(11)*y(2)*y(9)*(1-y(6))+y(14)*(x(7)+x(8))-y(6)*y(21);
residual(10)= lhs-rhs;
lhs =y(3);
rhs =params(1)*y(14);
residual(11)= lhs-rhs;
lhs =y(2);
rhs =(1-params(1))*y(14)/y(15)+1-params(3);
residual(12)= lhs-rhs;
lhs =y(14);
rhs =y(15)^(1-params(1));
residual(13)= lhs-rhs;
lhs =y(11);
rhs =y(15)+y(14)*x(5);
residual(14)= lhs-rhs;
lhs =y(19);
rhs =(1-y(9))*y(11);
residual(15)= lhs-rhs;
lhs =y(18);
rhs =y(9)*y(11);
residual(16)= lhs-rhs;
lhs =x(2)*x(1)*y(15);
rhs =y(15)*(1-params(3))+y(13);
residual(17)= lhs-rhs;
lhs =y(14);
rhs =y(10)+y(13)+y(14)*x(6);
residual(18)= lhs-rhs;
lhs =y(8);
rhs =(1-x(2)*x(1)/y(2))/T142;
residual(19)= lhs-rhs;
lhs =x(2)*x(1)*y(14)*x(5);
rhs =y(14)*(x(7)+x(8))+y(14)*x(6)+y(14)*y(2)*x(5)-y(20);
residual(20)= lhs-rhs;
lhs =y(21);
rhs =y(14)*(x(7)+x(8))+x(3)*y(21)*x(1)/y(2);
residual(21)= lhs-rhs;
lhs =y(22);
rhs =(1-x(4))*x(1)*y(4)*y(21)/(y(1)*y(2)*y(7))+x(4)*y(22)*x(1)/(y(2)*y(7));
residual(22)= lhs-rhs;
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
if nargout >= 2,
  g1 = zeros(22, 22);

  %
  % Jacobian matrix
  %

T180 = getPowerDeriv(y(2)*y(7),params(4)-1,1);
  g1(1,1)=x(2)-x(3);
  g1(2,2)=y(6)*x(3)*T20*getPowerDeriv(y(2),params(4)-1,1)/y(6);
  g1(2,6)=1;
  g1(3,2)=y(5)*T20*y(7)*T180/y(5);
  g1(3,5)=1;
  g1(3,7)=y(5)*T20*y(2)*T180/y(5);
  g1(4,4)=1;
  g1(4,5)=(-((-y(6))/(y(5)*y(5))));
  g1(4,6)=(-(1/y(5)));
  g1(5,4)=(-((1-x(4))*getPowerDeriv(y(4),1/(1-params(4)),1)));
  g1(5,7)=1;
  g1(6,2)=(-(y(5)*((1-y(9))*y(11)+y(4)*y(9)*y(11))));
  g1(6,4)=(-(y(5)*(y(11)*y(2)*y(9)+y(21))));
  g1(6,5)=(-(y(2)*(1-y(9))*y(11)+y(12)+y(22)+y(4)*(y(11)*y(2)*y(9)+y(21))));
  g1(6,9)=(-(y(5)*(y(11)*(-y(2))+y(4)*y(2)*y(11))));
  g1(6,10)=1;
  g1(6,11)=(-(y(5)*(y(2)*(1-y(9))+y(4)*y(2)*y(9))));
  g1(6,12)=(-y(5));
  g1(6,21)=(-(y(5)*y(4)));
  g1(6,22)=(-y(5));
  g1(7,2)=(-(y(5)*y(19)));
  g1(7,5)=(-(y(22)+y(12)+y(2)*y(19)));
  g1(7,12)=(-y(5));
  g1(7,17)=1;
  g1(7,19)=(-(y(2)*y(5)));
  g1(7,22)=(-y(5));
  g1(8,2)=(-(y(6)*y(18)));
  g1(8,6)=(-(y(21)+y(2)*y(18)));
  g1(8,16)=1;
  g1(8,18)=(-(y(6)*y(2)));
  g1(8,21)=(-y(6));
  g1(9,2)=(-((-(y(7)*y(12)*x(4)*x(1)))/(y(2)*y(7)*y(2)*y(7))));
  g1(9,7)=(-((-(y(2)*y(12)*x(4)*x(1)))/(y(2)*y(7)*y(2)*y(7))));
  g1(9,12)=T142;
  g1(9,14)=(-params(1));
  g1(9,20)=1;
  g1(10,2)=(-(y(11)*y(9)*(1-y(6))));
  g1(10,6)=(-(y(11)*y(2)*(-y(9))-y(21)));
  g1(10,9)=y(11)*x(2)*x(1)/x(4)-y(11)*y(2)*(1-y(6));
  g1(10,11)=x(2)*x(1)*(x(4)+y(9)-1)/x(4)-y(2)*y(9)*(1-y(6));
  g1(10,14)=(-(x(7)+x(8)));
  g1(10,21)=y(6);
  g1(11,3)=1;
  g1(11,14)=(-params(1));
  g1(12,2)=1;
  g1(12,14)=(-((1-params(1))*1/y(15)));
  g1(12,15)=(-((1-params(1))*(-y(14))/(y(15)*y(15))));
  g1(13,14)=1;
  g1(13,15)=(-(getPowerDeriv(y(15),1-params(1),1)));
  g1(14,11)=1;
  g1(14,14)=(-x(5));
  g1(14,15)=(-1);
  g1(15,9)=y(11);
  g1(15,11)=(-(1-y(9)));
  g1(15,19)=1;
  g1(16,9)=(-y(11));
  g1(16,11)=(-y(9));
  g1(16,18)=1;
  g1(17,13)=(-1);
  g1(17,15)=x(2)*x(1)-(1-params(3));
  g1(18,10)=(-1);
  g1(18,13)=(-1);
  g1(18,14)=1-x(6);
  g1(19,2)=(-((T142*(-((-(x(2)*x(1)))/(y(2)*y(2))))-(1-x(2)*x(1)/y(2))*(-((-(y(7)*x(4)*x(1)))/(y(2)*y(7)*y(2)*y(7)))))/(T142*T142)));
  g1(19,7)=(-((-((1-x(2)*x(1)/y(2))*(-((-(y(2)*x(4)*x(1)))/(y(2)*y(7)*y(2)*y(7))))))/(T142*T142)));
  g1(19,8)=1;
  g1(20,2)=(-(y(14)*x(5)));
  g1(20,14)=x(2)*x(1)*x(5)-(x(7)+x(8)+x(6)+y(2)*x(5));
  g1(20,20)=1;
  g1(21,2)=(-((-(x(3)*y(21)*x(1)))/(y(2)*y(2))));
  g1(21,14)=(-(x(7)+x(8)));
  g1(21,21)=1-x(3)*x(1)/y(2);
  g1(22,1)=(-((1-x(4))*(-(y(2)*y(7)*x(1)*y(4)*y(21)))/(y(1)*y(2)*y(7)*y(1)*y(2)*y(7))));
  g1(22,2)=(-((1-x(4))*(-(x(1)*y(4)*y(21)*y(1)*y(7)))/(y(1)*y(2)*y(7)*y(1)*y(2)*y(7))+(-(y(7)*x(4)*y(22)*x(1)))/(y(2)*y(7)*y(2)*y(7))));
  g1(22,4)=(-((1-x(4))*y(21)*x(1)/(y(1)*y(2)*y(7))));
  g1(22,7)=(-((1-x(4))*(-(x(1)*y(4)*y(21)*y(1)*y(2)))/(y(1)*y(2)*y(7)*y(1)*y(2)*y(7))+(-(y(2)*x(4)*y(22)*x(1)))/(y(2)*y(7)*y(2)*y(7))));
  g1(22,21)=(-((1-x(4))*y(4)*x(1)/(y(1)*y(2)*y(7))));
  g1(22,22)=T142;
  if ~isreal(g1)
    g1 = real(g1)+2*imag(g1);
  end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],22,484);
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],22,10648);
end
end
end
end
